// VMeansList.java
// Version 0.4 
// Last Updated: 10/16/2000
// Used by ClusterManager

package Alkindi.Services.InternalData;

import java.util.ArrayList;
import java.util.Iterator;

/* 
$Header: VMeansList.java, 20, 4/26/01 2:37:00 PM, Schwartz, Joe$
$Log: 
 20   Alkindi Development1.19        4/26/01 2:37:00 PM   Schwartz, Joe  
      Modifed to account for movement to new packages.
 19   Alkindi Development1.18        4/26/01 1:46:09 PM   Schwartz, Joe   Moved
      to new package.
 18   Alkindi Development1.17        2/22/01 3:14:18 PM   Schwartz, Joe   Added
      methods for filling routines. 
 17   Alkindi Development1.16        2/14/01 6:22:17 PM   Schwartz, Joe  
      Changed logging to use StringBuffer instead of Strings. Change to match
      new RatingSpacePoint and SparseRatingsArray classes.
 16   Alkindi Development1.15        2/14/01 12:19:48 PM  Schwartz, Joe  
      Modifed dump() method to use StringBuffer.
 15   Alkindi Development1.14        1/26/01 5:48:32 PM   Schwartz, Joe  
      Improving efficiency.
 14   Alkindi Development1.13        1/22/01 1:46:42 PM   Schwartz, Joe  
      Modified to account for new RatingSpacePoint base class of VMeans &
      UserCluster.
 13   Alkindi Development1.12        1/21/01 4:40:11 PM   Schwartz, Joe  
      orrected class definition to include Cloneable interface. Eliminated
      constructors from clone() body.
 12   Alkindi Development1.11        12/28/00 1:07:29 PM  Schwartz, Joe   Added
      Version Control header info.
 11   Alkindi Development1.10        12/26/00 6:57:18 PM  Schwartz, Joe   
 10   Alkindi Development1.9         12/18/00 12:06:26 PM Schwartz, Joe   Moved
      from (public) BusinessDataTypes package.
 9    Alkindi Development1.8         12/15/00 6:17:01 PM  Schwartz, Joe  
      Changed internal storage to ArrayList.
 8    Alkindi Development1.7         12/3/00 7:51:19 PM   Schwartz, Joe   
 7    Alkindi Development1.6         12/3/00 5:28:01 PM   Schwartz, Joe   
 6    Alkindi Development1.5         12/2/00 1:02:14 PM   Schwartz, Joe   
 5    Alkindi Development1.4         12/2/00 10:47:14 AM  Schwartz, Joe   
 4    Alkindi Development1.3         10/22/00 10:38:49 AM Schwartz, Joe  
      AppianDelivery 10.20.00
 3    Alkindi Development1.2         10/22/00 10:33:57 AM Schwartz, Joe   
 2    Alkindi Development1.1         10/17/00 2:16:36 PM  Schwartz, Joe  
      Delivery 10.16.00
 1    Alkindi Development1.0         10/7/00 4:26:04 PM   Schwartz, Joe   
$
$NoKeywords$
 */

/**
 */
public class VMeansList implements Cloneable 
{
	private ArrayList internalList;
	
	public VMeansList() 
	{
		internalList = new ArrayList();
	}
	
	/**
	 * @roseuid 3A290EEA01F4
	 */
	public void add(VMeans itemToAdd) 
	{
		internalList.add(itemToAdd);
	}
	
	/**
	 * @roseuid 3A71ED0A0109
	 */
	public final void add(final int pos, final VMeans item) 
	{
		internalList.add(pos, item);
	}
	
	/**
	 * @roseuid 3A393D900203
	 */
	public void clear() 
	{
		internalList.clear();
	}
	
	/**
	 * Performs a deep copy of the object, including cloning the VMeans contained in internalList.
	 * @return A deep copy of the VMeansList instance.
	 * @roseuid 3A2ADB2501C5
	 */
	public java.lang.Object clone() 
	{
		try {
			VMeansList newList = (VMeansList)super.clone();
			newList.internalList = (ArrayList)internalList.clone();
			newList.internalList.clear();
			int numVMeans = internalList.size();
			for (int idx = 0; idx<numVMeans; idx++ ) {
				VMeans vm = (VMeans)internalList.get(idx);
				newList.add((VMeans)vm.clone());
			}
			return newList;
		}
		catch(CloneNotSupportedException cne) {
			//	This exception should never occur, as both this class and its parent
			//	support the Cloneable interface. If it does occur, it is a 
			//	serious internal error in the JVM, and is handled as such.
			//
			throw new InternalError();
		}
	}
	
	/**
	 * @roseuid 3A2980690222
	 */
	public String dump() 
	{
		StringBuffer retBuf = new StringBuffer("VMeansList Dump:\n");
		Iterator it = iterator();
		int vmIdx = 0;
		while (it.hasNext()) {
			retBuf.append("VMEANS LIST ITEM " + vmIdx + "\n");
			vmIdx++;
			retBuf.append(((VMeans)it.next()).dump());
		}
		retBuf.append("VMeansList Dump done.");
		return retBuf.toString();
	}
	
	/**
	 * @roseuid 3A290EEF001F
	 */
	public VMeans get(int idx) 
	{
		return (VMeans) internalList.get(idx);
	}
	
	/**
	 * @roseuid 3A290EED0213
	 */
	public Iterator iterator() 
	{
		return internalList.iterator();
	}
	
	/**
	 * @roseuid 3A290EFB02CE
	 */
	public VMeans set(int pos, VMeans newObj) 
	{
		return (VMeans)internalList.set(pos, newObj);
	}
	
	/**
	 * @roseuid 3A290EEC006D
	 */
	public int size() 
	{
		return internalList.size();
	}
	
	/**
	 * @roseuid 3A290EAE006D
	 */
	public VMeansList(final int size) 
	{
		internalList = new ArrayList(size);
	}
	
	/**
	 * Retrives a matrix of mutual distances for all points in the list. The matrix dimensions are size() X size().
	 * @param power The power to use in distance calculations.
	 * @return A  double[][] matrix representing the distances.
	 * @throws IndexOutOfBoundsException when if the internal list is empty.
	 * @roseuid 3A9548A80138
	 */
	public double[][] getDistanceMatrix(final float power) throws IndexOutOfBoundsException 
	{
		int numPoints = internalList.size();
		if (numPoints == 0)
			throw new IndexOutOfBoundsException();
			
		double[][] distances = new double[numPoints][numPoints];
		
		for (int ptIdx1 = 0; ptIdx1 < numPoints; ptIdx1 ++) {
			//	Distance from a point to itself is 0
			//
			distances[ptIdx1][ptIdx1] = 0;
			//	Use symmetry (Dij = Dji) to skip 1/2 of the remaining calculations.
			//
			for (int ptIdx2 = ptIdx1 + 1; ptIdx2 < numPoints; ptIdx2 ++) {
				distances[ptIdx1][ptIdx2] = ((VMeans)internalList.get(ptIdx1)).distance((VMeans)internalList.get(ptIdx2), power);
				distances[ptIdx2][ptIdx1] = distances[ptIdx1][ptIdx2];
			}
		}
		return distances;
	}
	
	/**
	 * Retrives the Sparsity matrix for all points and products in the list. The matrix dimensions are (numPoints, numProducts), and the element type is boolean. This uses the number of products in the first point as a basis for comparison. Each element of the matrix is either true or false, meaning the point has or lacks data, respectively, for the product. 
	 * @return A  matrix (boolean[numPoints][numProducts] ) representing the distances.
	 * @throws IndexOutOfBoundsException when if the internal list is empty.
	 * @roseuid 3A954BBC00CB
	 */
	public boolean[][] getSparsityMatrix() throws IndexOutOfBoundsException 
	{
		int numPoints = internalList.size();
		if (numPoints == 0) 
			throw new IndexOutOfBoundsException();

		int[] prodAr = ((VMeans)internalList.get(0)).getProductArray();
		int numProds = prodAr.length;

		boolean[][] sparsity = new boolean[numPoints][numProds];
		for (int ptIdx = 0; ptIdx < numPoints; ptIdx++) {
			VMeans pt = (VMeans)internalList.get(ptIdx);
			for (int prodIdx = 0; prodIdx < numProds; prodIdx ++) {
				int pid = prodAr[prodIdx];
				sparsity[ptIdx][prodIdx] = pt.getEval(pid) > 0D;
			} // end loop over products

		} // end loop over points
		return sparsity;
	}
}
